/*
 * Decompiled with CFR 0.152.
 */
package com.freecode.mathquiz.activities;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.freecode.mathquiz.MainActivity;
import com.freecode.mathquiz.activities.StartGameActivity;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsShowOptions;
import java.util.Random;

public class QuizResultActivity
extends AppCompatActivity
implements IUnityAdsInitializationListener {
    TextView theScoreTxt;
    TextView bestScoreTxt;
    TextView gameDifficultyTxt;
    int gameScore;
    int bestScoreInt;
    public SharedPreferences prefs;
    private AdView adView;
    private InterstitialAd interstitialAd;
    private ProgressDialog pDialog;
    private String GameDifficulty;
    ImageView ResultImg;
    ImageView cupImg;
    TextView rightAnswersText;
    TextView bestScoreText;
    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener(){

        public void onUnityAdsAdLoaded(String placementId) {
            UnityAds.show((Activity)QuizResultActivity.this, (String)QuizResultActivity.this.getString(2131820589), (UnityAdsShowOptions)new UnityAdsShowOptions(), (IUnityAdsShowListener)QuizResultActivity.this.showListener);
        }

        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
            Log.e((String)"UnityAdsExample", (String)("Unity Ads failed to load ad for " + placementId + " with error: [" + error + "] " + message));
        }
    };
    private final IUnityAdsShowListener showListener = new IUnityAdsShowListener(){

        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
            Log.e((String)"UnityAdsExample", (String)("Unity Ads failed to show ad for " + placementId + " with error: [" + error + "] " + message));
        }

        public void onUnityAdsShowStart(String placementId) {
            Log.v((String)"UnityAdsExample", (String)("onUnityAdsShowStart: " + placementId));
        }

        public void onUnityAdsShowClick(String placementId) {
            Log.v((String)"UnityAdsExample", (String)("onUnityAdsShowClick: " + placementId));
        }

        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            Log.v((String)"UnityAdsExample", (String)("onUnityAdsShowComplete: " + placementId));
            if (state.equals((Object)UnityAds.UnityAdsShowCompletionState.COMPLETED)) {
                // empty if block
            }
        }
    };

    @SuppressLint(value={"SetTextI18n"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492895);
        this.LoadAds();
        this.setBannerAds();
        this.theScoreTxt = (TextView)this.findViewById(2131296761);
        this.bestScoreTxt = (TextView)this.findViewById(2131296760);
        this.gameDifficultyTxt = (TextView)this.findViewById(2131296492);
        this.rightAnswersText = (TextView)this.findViewById(2131296644);
        this.bestScoreText = (TextView)this.findViewById(2131296360);
        this.ResultImg = (ImageView)this.findViewById(2131296640);
        this.cupImg = (ImageView)this.findViewById(2131296261);
        this.ResultImg.setImageBitmap(QuizResultActivity.decodeSampledBitmapFromResource(this.getResources(), 2131165428, 100, 100));
        this.cupImg.setImageBitmap(QuizResultActivity.decodeSampledBitmapFromResource(this.getResources(), 0x7F070077, 100, 100));
        Bundle resultBundle = this.getIntent().getExtras();
        this.gameScore = resultBundle.getInt("theResult");
        this.GameDifficulty = resultBundle.getString("Difficulty");
        this.theScoreTxt.setText((CharSequence)("" + this.gameScore));
        this.gameDifficultyTxt.setText((CharSequence)("Game Difficulty: " + this.GameDifficulty));
        this.prefs = this.getSharedPreferences("prefBestScore", 0);
        this.bestScoreInt = this.prefs.getInt(this.GameDifficulty, 0);
        if (this.gameScore > this.bestScoreInt) {
            this.newRecord(this.gameScore);
            this.bestScoreTxt.setText((CharSequence)("" + this.gameScore));
        } else {
            this.bestScoreTxt.setText((CharSequence)("" + this.bestScoreInt));
        }
        this.setAch();
        Animation txtAnim = AnimationUtils.loadAnimation((Context)this, (int)2130772003);
        this.rightAnswersText.startAnimation(txtAnim);
        this.bestScoreText.startAnimation(txtAnim);
        Animation scoreAnim = AnimationUtils.loadAnimation((Context)this, (int)2130771983);
        this.theScoreTxt.startAnimation(scoreAnim);
        this.bestScoreTxt.startAnimation(scoreAnim);
        Animation imgAnim = AnimationUtils.loadAnimation((Context)this, (int)2130772014);
        this.ResultImg.startAnimation(imgAnim);
        UnityAds.initialize((Context)this.getApplicationContext(), (String)this.getString(2131820761), (boolean)false, (IUnityAdsInitializationListener)this);
    }

    private void newRecord(int newRecord) {
        SharedPreferences.Editor editor;
        if (this.GameDifficulty.contains("easy")) {
            this.prefs = this.getSharedPreferences("prefBestScore", 0);
            editor = this.prefs.edit();
            editor.putInt("easy", newRecord);
            editor.apply();
        }
        if (this.GameDifficulty.contains("medium")) {
            this.prefs = this.getSharedPreferences("prefBestScore", 0);
            editor = this.prefs.edit();
            editor.putInt("medium", newRecord);
            editor.apply();
        }
        if (this.GameDifficulty.contains("hard")) {
            this.prefs = this.getSharedPreferences("prefBestScore", 0);
            editor = this.prefs.edit();
            editor.putInt("hard", newRecord);
            editor.apply();
        }
        if (this.GameDifficulty.contains("random")) {
            this.prefs = this.getSharedPreferences("prefBestScore", 0);
            editor = this.prefs.edit();
            editor.putInt("random", newRecord);
            editor.apply();
        }
    }

    private void setBannerAds() {
        MobileAds.initialize((Context)this, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
            }
        });
        this.adView = (AdView)this.findViewById(2131296333);
        AdRequest adRequest = new AdRequest.Builder().build();
        this.adView.loadAd(adRequest);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.showNetworkAds();
    }

    public void PlayAgainClick(View view) {
        Bundle difficulty = new Bundle();
        difficulty.putString("difficulty", this.GameDifficulty);
        Intent playAgain = new Intent((Context)this, StartGameActivity.class);
        playAgain.putExtras(difficulty);
        this.startActivity(playAgain);
        this.finish();
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = QuizResultActivity.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public void BackClick(View view) {
        this.showNetworkAds();
    }

    public void LoadAds() {
        AdRequest adRequest = new AdRequest.Builder().build();
        InterstitialAd.load((Context)this, (String)this.getString(2131820593), (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                QuizResultActivity.this.interstitialAd = interstitialAd;
                Log.i((String)"TAG", (String)"onAdLoaded");
                interstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdDismissedFullScreenContent() {
                        QuizResultActivity.this.interstitialAd = null;
                        Log.d((String)"TAG", (String)"The ad was dismissed.");
                        Intent back = new Intent((Context)QuizResultActivity.this, MainActivity.class);
                        QuizResultActivity.this.startActivity(back);
                        QuizResultActivity.this.finish();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        QuizResultActivity.this.interstitialAd = null;
                        Log.d((String)"TAG", (String)"The ad failed to show.");
                    }

                    public void onAdShowedFullScreenContent() {
                        Log.d((String)"TAG", (String)"The ad was shown.");
                    }
                });
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.i((String)"TAG", (String)loadAdError.getMessage());
                QuizResultActivity.this.interstitialAd = null;
            }
        });
    }

    private void showInterstitial() {
        if (this.interstitialAd != null) {
            this.interstitialAd.show((Activity)this);
        } else {
            Intent back = new Intent((Context)this, MainActivity.class);
            this.startActivity(back);
            this.finish();
        }
    }

    protected void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
        }
        super.onDestroy();
    }

    public void onInitializationComplete() {
    }

    public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
        Log.e((String)"UnityAdsExample", (String)("Unity Ads initialization failed with error: [" + error + "] " + message));
    }

    public void DisplayRewardedAd() {
        UnityAds.load((String)this.getString(2131820589), (IUnityAdsLoadListener)this.loadListener);
    }

    private void showNetworkAds() {
        if (this.getString(2131820590).contains("On") && this.getString(2131820762).contains("On")) {
            int max = 2;
            int min = 1;
            int random = new Random().nextInt(max - min + 1) + min;
            if (random == 1) {
                this.showInterstitial();
            } else {
                this.DisplayRewardedAd();
            }
        } else if (this.getString(2131820590).contains("On")) {
            this.showInterstitial();
        } else if (this.getString(2131820762).contains("On")) {
            this.DisplayRewardedAd();
        } else {
            this.showInterstitial();
        }
    }

    private void setAch() {
        this.prefs = this.getSharedPreferences("achievement", 0);
        if (this.bestScoreInt >= 5) {
            this.prefs.edit().putInt("Score_5_Ach", 1).apply();
        }
        if (this.bestScoreInt >= 10) {
            this.prefs.edit().putInt("Score_10_Ach", 1).apply();
        }
        if (this.bestScoreInt >= 50) {
            this.prefs.edit().putInt("Score_50_Ach", 1).apply();
        }
    }
}

