/*
 * Decompiled with CFR 0.152.
 */
package com.freecode.mathquiz.activities;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.freecode.mathquiz.activities.QuizResultActivity;
import com.freecode.mathquiz.helper.Questions;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class StartGameActivity
extends AppCompatActivity {
    private TextView textViewTime;
    private TextView questionText;
    private TextView numberOfQuestion;
    private Button btn_AnswerOne;
    private Button btn_AnswerTwo;
    private Button btn_AnswerThree;
    private Button btn_AnswerFour;
    private AdView adView;
    private Questions questions;
    private ProgressBar progressBar;
    private CountDownTimer myTimer;
    private int QuestionRandomId;
    private int RightCount;
    private int WrongCount;
    private int QuestionNumber = 1;
    public SharedPreferences prefs;
    private String theCorrectAnswer;
    private MediaPlayer quizTimerSound;
    final long timeCountInMilliSeconds = 30000L;
    private String DifficultyGame;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492897);
        Bundle DifficultyBundle = this.getIntent().getExtras();
        this.DifficultyGame = DifficultyBundle.getString("difficulty");
        this.numberOfQuestion = (TextView)this.findViewById(2131296265);
        this.questionText = (TextView)this.findViewById(2131296266);
        this.btn_AnswerOne = (Button)this.findViewById(2131296383);
        this.btn_AnswerTwo = (Button)this.findViewById(2131296385);
        this.btn_AnswerThree = (Button)this.findViewById(2131296384);
        this.btn_AnswerFour = (Button)this.findViewById(2131296382);
        this.progressBar = (ProgressBar)this.findViewById(2131296634);
        this.textViewTime = (TextView)this.findViewById(2131296731);
        this.setBannerAds();
        this.getNextQuestion();
        this.setProgressTimer();
        this.questionText.setShadowLayer(5.0f, 1.0f, 1.0f, -16777216);
        this.btn_AnswerOne.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StartGameActivity.this.btn_AnswerOne.getText().toString() == StartGameActivity.this.theCorrectAnswer) {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("rightQuizStat", StartGameActivity.this.RightCount);
                    StartGameActivity.this.delayNextQuestion();
                    StartGameActivity.this.CorrectAnswer(StartGameActivity.this.btn_AnswerOne);
                } else {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("wrongQuizStat", StartGameActivity.this.WrongCount);
                    StartGameActivity.this.delayExit();
                    StartGameActivity.this.WrongAnswer(StartGameActivity.this.btn_AnswerOne);
                }
            }
        });
        this.btn_AnswerTwo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StartGameActivity.this.btn_AnswerTwo.getText().toString() == StartGameActivity.this.theCorrectAnswer) {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("rightQuizStat", StartGameActivity.this.RightCount);
                    StartGameActivity.this.delayNextQuestion();
                    StartGameActivity.this.CorrectAnswer(StartGameActivity.this.btn_AnswerTwo);
                } else {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("wrongQuizStat", StartGameActivity.this.WrongCount);
                    StartGameActivity.this.delayExit();
                    StartGameActivity.this.WrongAnswer(StartGameActivity.this.btn_AnswerTwo);
                }
            }
        });
        this.btn_AnswerThree.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StartGameActivity.this.btn_AnswerThree.getText().toString() == StartGameActivity.this.theCorrectAnswer) {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("rightQuizStat", StartGameActivity.this.RightCount);
                    StartGameActivity.this.delayNextQuestion();
                    StartGameActivity.this.CorrectAnswer(StartGameActivity.this.btn_AnswerThree);
                } else {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("wrongQuizStat", StartGameActivity.this.WrongCount);
                    StartGameActivity.this.delayExit();
                    StartGameActivity.this.WrongAnswer(StartGameActivity.this.btn_AnswerThree);
                }
            }
        });
        this.btn_AnswerFour.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StartGameActivity.this.btn_AnswerFour.getText().toString() == StartGameActivity.this.theCorrectAnswer) {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("rightQuizStat", StartGameActivity.this.RightCount);
                    StartGameActivity.this.delayNextQuestion();
                    StartGameActivity.this.CorrectAnswer(StartGameActivity.this.btn_AnswerFour);
                } else {
                    StartGameActivity.this.myTimer.cancel();
                    StartGameActivity.this.setQuizStatistic("wrongQuizStat", StartGameActivity.this.WrongCount);
                    StartGameActivity.this.delayExit();
                    StartGameActivity.this.WrongAnswer(StartGameActivity.this.btn_AnswerFour);
                }
            }
        });
    }

    private void setProgressTimer() {
        this.myTimer = new CountDownTimer(30000L, 1000L){

            public void onTick(long millisUntilFinished) {
                long time = millisUntilFinished / 1000L;
                StartGameActivity.this.progressBar.setProgress(Integer.parseInt(String.valueOf(time)));
                StartGameActivity.this.textViewTime.setText((CharSequence)StartGameActivity.this.hmsTimeFormatter(millisUntilFinished));
                if (Integer.parseInt(String.valueOf(time)) <= 15) {
                    StartGameActivity.this.textViewTime.setShadowLayer(5.0f, 1.0f, 1.0f, -16777216);
                    StartGameActivity.this.textViewTime.setTextColor(StartGameActivity.this.getResources().getColor(2131034979));
                } else {
                    StartGameActivity.this.textViewTime.setShadowLayer(1.0f, 1.0f, 1.0f, -16777216);
                    StartGameActivity.this.textViewTime.setTextColor(StartGameActivity.this.getResources().getColor(2131035016));
                }
            }

            public void onFinish() {
                Bundle bundle = new Bundle();
                bundle.putInt("theResult", StartGameActivity.this.QuestionNumber - 1);
                bundle.putString("Difficulty", StartGameActivity.this.DifficultyGame);
                Intent outIntent = new Intent((Context)StartGameActivity.this, QuizResultActivity.class);
                outIntent.putExtras(bundle);
                StartGameActivity.this.startActivity(outIntent);
                StartGameActivity.this.myTimer.cancel();
                StartGameActivity.this.quizTimerSound.stop();
                StartGameActivity.this.textViewTime.setText((CharSequence)StartGameActivity.this.hmsTimeFormatter(30000L));
                StartGameActivity.this.finish();
            }
        }.start();
    }

    private String hmsTimeFormatter(long milliSeconds) {
        String hms = String.format("%02d", TimeUnit.MILLISECONDS.toSeconds(milliSeconds) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(milliSeconds)));
        return hms;
    }

    private void delayExit() {
        this.quizTimerSound.stop();
        this.disableClickButton();
        if (this.btn_AnswerOne.getText().toString() == this.theCorrectAnswer) {
            this.CorrectAnswer(this.btn_AnswerOne);
        }
        if (this.btn_AnswerTwo.getText().toString() == this.theCorrectAnswer) {
            this.CorrectAnswer(this.btn_AnswerTwo);
        }
        if (this.btn_AnswerThree.getText().toString() == this.theCorrectAnswer) {
            this.CorrectAnswer(this.btn_AnswerThree);
        }
        if (this.btn_AnswerFour.getText().toString() == this.theCorrectAnswer) {
            this.CorrectAnswer(this.btn_AnswerFour);
        }
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putInt("theResult", StartGameActivity.this.QuestionNumber - 1);
                bundle.putString("Difficulty", StartGameActivity.this.DifficultyGame);
                Intent outIntent = new Intent((Context)StartGameActivity.this, QuizResultActivity.class);
                outIntent.putExtras(bundle);
                StartGameActivity.this.startActivity(outIntent);
                StartGameActivity.this.finish();
            }
        }, 2000L);
    }

    private void delayNextQuestion() {
        this.quizTimerSound.stop();
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                StartGameActivity.this.QuestionNumber++;
                StartGameActivity.this.getNextQuestion();
                StartGameActivity.this.enableClickButton();
                StartGameActivity.this.setProgressTimer();
            }
        }, 2000L);
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables", "SetTextI18n"})
    private void getNextQuestion() {
        this.quizTimerSound = MediaPlayer.create((Context)this, (int)2131755009);
        this.numberOfQuestion.setText((CharSequence)("" + this.getString(2131820551) + " " + this.QuestionNumber));
        this.setQuestionAnimation();
        this.setOptionsAnimation();
        this.getGameDifficulty();
        this.quizTimerSound.start();
        this.btn_AnswerOne.setBackground(this.getDrawable(2131165316));
        this.btn_AnswerTwo.setBackground(this.getDrawable(2131165316));
        this.btn_AnswerThree.setBackground(this.getDrawable(2131165316));
        this.btn_AnswerFour.setBackground(this.getDrawable(2131165316));
    }

    private void getGameDifficulty() {
        String[] theQuestion;
        if (this.DifficultyGame.toString().contains("easy")) {
            this.QuestionRandomId = this.randomNumber(1, 50);
            theQuestion = Questions.getQuestionAndOptionsEasy(this.QuestionRandomId);
            this.questionText.setText((CharSequence)theQuestion[0]);
            this.btn_AnswerOne.setText((CharSequence)theQuestion[1]);
            this.btn_AnswerTwo.setText((CharSequence)theQuestion[2]);
            this.btn_AnswerThree.setText((CharSequence)theQuestion[3]);
            this.btn_AnswerFour.setText((CharSequence)theQuestion[4]);
            this.theCorrectAnswer = theQuestion[5];
        }
        if (this.DifficultyGame.contains("medium")) {
            this.QuestionRandomId = this.randomNumber(1, 50);
            theQuestion = Questions.getQuestionAndOptionsMedium(this.QuestionRandomId);
            this.questionText.setText((CharSequence)theQuestion[0]);
            this.btn_AnswerOne.setText((CharSequence)theQuestion[1]);
            this.btn_AnswerTwo.setText((CharSequence)theQuestion[2]);
            this.btn_AnswerThree.setText((CharSequence)theQuestion[3]);
            this.btn_AnswerFour.setText((CharSequence)theQuestion[4]);
            this.theCorrectAnswer = theQuestion[5];
        }
        if (this.DifficultyGame.contains("hard")) {
            this.QuestionRandomId = this.randomNumber(1, 50);
            theQuestion = Questions.getQuestionAndOptionsHard(this.QuestionRandomId);
            this.questionText.setText((CharSequence)theQuestion[0]);
            this.btn_AnswerOne.setText((CharSequence)theQuestion[1]);
            this.btn_AnswerTwo.setText((CharSequence)theQuestion[2]);
            this.btn_AnswerThree.setText((CharSequence)theQuestion[3]);
            this.btn_AnswerFour.setText((CharSequence)theQuestion[4]);
            this.theCorrectAnswer = theQuestion[5];
        }
        if (this.DifficultyGame.contains("random")) {
            this.QuestionRandomId = this.randomNumber(1, 100);
            theQuestion = Questions.getQuestionAndOptions(this.QuestionRandomId);
            this.questionText.setText((CharSequence)theQuestion[0]);
            this.btn_AnswerOne.setText((CharSequence)theQuestion[1]);
            this.btn_AnswerTwo.setText((CharSequence)theQuestion[2]);
            this.btn_AnswerThree.setText((CharSequence)theQuestion[3]);
            this.btn_AnswerFour.setText((CharSequence)theQuestion[4]);
            this.theCorrectAnswer = theQuestion[5];
        }
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    private void CorrectAnswer(Button button) {
        button.setBackground(this.getDrawable(2131165309));
        int levelTimer = Integer.parseInt(this.textViewTime.getText().toString());
        if (levelTimer >= 25) {
            this.prefs = this.getSharedPreferences("achievement", 0);
            this.prefs.edit().putInt("TimerAch", 1).apply();
        }
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    private void WrongAnswer(Button button) {
        button.setBackground(this.getDrawable(2131165315));
    }

    private void enableClickButton() {
        this.btn_AnswerOne.setClickable(true);
        this.btn_AnswerTwo.setClickable(true);
        this.btn_AnswerThree.setClickable(true);
        this.btn_AnswerFour.setClickable(true);
    }

    private void disableClickButton() {
        this.btn_AnswerOne.setClickable(false);
        this.btn_AnswerTwo.setClickable(false);
        this.btn_AnswerThree.setClickable(false);
        this.btn_AnswerFour.setClickable(false);
    }

    private void setProgressValue(final int progress) {
        this.progressBar.setProgress(progress);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StartGameActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (StartGameActivity.this.progressBar.getProgress() < StartGameActivity.this.progressBar.getMax()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            StartGameActivity.this.setProgressValue(progress + 1);
                        } else {
                            Looper.myLooper().quit();
                            Toast.makeText((Context)StartGameActivity.this.getApplicationContext(), (CharSequence)StartGameActivity.this.getString(2131820557), (int)1).show();
                        }
                    }
                });
            }
        });
        thread.start();
    }

    private int randomNumber(int min, int max) {
        Random random = new Random();
        int rr = random.nextInt(max - min) + min;
        return rr;
    }

    private void setQuizStatistic(String key, int count) {
        this.prefs = this.getSharedPreferences("prefName", 0);
        count = this.prefs.getInt(key, 0);
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putInt(key, ++count);
        editor.commit();
    }

    private void setQuestionAnimation() {
        Animation queAnim = AnimationUtils.loadAnimation((Context)this, (int)2130771980);
        this.questionText.startAnimation(queAnim);
    }

    private void setOptionsAnimation() {
        Animation queAnim = AnimationUtils.loadAnimation((Context)this, (int)2130772003);
        this.btn_AnswerOne.startAnimation(queAnim);
        this.btn_AnswerTwo.startAnimation(queAnim);
        Animation queAnimfast = AnimationUtils.loadAnimation((Context)this, (int)2130772003);
        this.btn_AnswerThree.startAnimation(queAnimfast);
        this.btn_AnswerFour.startAnimation(queAnimfast);
    }

    private void setBannerAds() {
        MobileAds.initialize((Context)this, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
            }
        });
        this.adView = (AdView)this.findViewById(2131296333);
        AdRequest adRequest = new AdRequest.Builder().build();
        this.adView.loadAd(adRequest);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.myTimer.cancel();
        this.quizTimerSound.stop();
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        this.quizTimerSound.stop();
    }

    protected void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
        }
        super.onDestroy();
        this.quizTimerSound.stop();
    }
}

